/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.data.jai.BufferedImageContainer;
import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDescriptor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class DFT
extends AbstractJAIFlattener {
    private static final long serialVersionUID = 3993399058139605286L;

    public String globalInfo() {
        return "Performs discrete fourier transform (DFT).";
    }

    @Override
    public Instances createHeader(BufferedImageContainer img) {
        double[] values = this.performDFT(img);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 == 0) {
                atts.add(new Attribute("real_" + (i / 2 + 1)));
                continue;
            }
            atts.add(new Attribute("imag_" + (i / 2 + 1)));
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    protected double[] performDFT(BufferedImageContainer img) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(PlanarImage.wrapRenderedImage((RenderedImage)((RenderedImage)img.getImage())));
        pb.add(DFTDescriptor.SCALING_NONE);
        pb.add(DFTDescriptor.REAL_TO_COMPLEX);
        RenderedOp dft = JAI.create((String)"dft", (ParameterBlock)pb, null);
        Raster dftData = dft.getData();
        double[] real = dftData.getSamples(0, 0, dft.getWidth(), dft.getHeight(), 0, (double[])null);
        double[] imag = dftData.getSamples(0, 0, dft.getWidth(), dft.getHeight(), 1, (double[])null);
        double[] values = this.newArray(real.length + imag.length);
        for (int i = 0; i < real.length; ++i) {
            values[i * 2 + 0] = real[i];
            values[i * 2 + 1] = imag[i];
        }
        return values;
    }

    @Override
    public Instance[] doFlatten(BufferedImageContainer img) {
        double[] values = this.performDFT(img);
        Instance[] result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }
}

