/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.data.jai.BufferedImageContainer;
import adams.data.jai.flattener.AbstractJAIFlattener;
import adams.data.jai.flattener.Pixels;
import adams.data.jai.transformer.Crop;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.PixelSelector;
import adams.flow.transformer.pixelselector.AddClassification;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.RenameAttribute;

public class PixelClassifications
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -511904410456677378L;
    protected int m_Width;
    protected int m_Height;
    protected Crop.Anchor m_Anchor;
    protected boolean m_SeparateRGB;

    public String globalInfo() {
        return "Generates an instance for each pixel classification that is stored in the image's report.\nPixel classifications are generated with the " + PixelSelector.class.getName() + " transformer, using the " + AddClassification.class.getName() + " action.\n" + "Automatically adds the classification label associated with a " + "classification position in the report as a separate attribute.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)100, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)75, (Number)1, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)Crop.Anchor.TOP_LEFT);
        this.m_OptionManager.add("separate-rgb", "separateRGB", (Object)false);
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getSystemErr().println("Width has to be >0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle.";
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getSystemErr().println("Height has to be >0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle.";
    }

    public void setAnchor(Crop.Anchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public Crop.Anchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    public void setSeparateRGB(boolean value) {
        this.m_SeparateRGB = value;
        this.reset();
    }

    public boolean getSeparateRGB() {
        return this.m_SeparateRGB;
    }

    public String separateRGBTipText() {
        return "Whether to output the RGB values as separate attributes or a single combined one.";
    }

    @Override
    public Instances createHeader(BufferedImageContainer img) {
        Crop crop = new Crop();
        crop.setWidth(this.m_Width);
        crop.setHeight(this.m_Height);
        crop.setAnchor(Crop.Anchor.TOP_LEFT);
        crop.setX(1);
        crop.setY(1);
        img = ((BufferedImageContainer[])crop.transform(img))[0];
        crop.destroy();
        Pixels pixels = new Pixels();
        pixels.setSeparateRGB(this.m_SeparateRGB);
        Instances result = pixels.createHeader(img);
        pixels.destroy();
        return result;
    }

    protected Integer[] getClassificationIndices(BufferedImageContainer img) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Vector fields = img.getReport().getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith("Classification.")) continue;
            result.add(Integer.parseInt(field.getName().substring("Classification.".length())));
        }
        return result.toArray(new Integer[result.size()]);
    }

    protected Point getPixelLocation(BufferedImageContainer img, int index) {
        Report report;
        Point result = null;
        if (img != null && img.hasReport() && (report = img.getReport()).hasValue("Pixel.X." + index) && report.hasValue("Pixel.Y." + index)) {
            result = new Point(report.getDoubleValue("Pixel.X." + index).intValue(), report.getDoubleValue("Pixel.Y." + index).intValue());
        }
        return result;
    }

    @Override
    public Instance[] doFlatten(BufferedImageContainer img) {
        Integer[] indices;
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Integer index : indices = this.getClassificationIndices(img)) {
            Point loc = this.getPixelLocation(img, index);
            Crop crop = new Crop();
            crop.setWidth(this.m_Width);
            crop.setHeight(this.m_Height);
            crop.setAnchor(this.m_Anchor);
            crop.setX((int)(loc.getX() + 1.0));
            crop.setY((int)(loc.getY() + 1.0));
            BufferedImageContainer cropped = ((BufferedImageContainer[])crop.transform(img))[0];
            crop.destroy();
            Pixels pixels = new Pixels();
            pixels.setSeparateRGB(this.m_SeparateRGB);
            pixels.setFields(new Field[]{new Field("Classification." + index, DataType.STRING)});
            Instance[] inst = pixels.flatten(cropped);
            pixels.destroy();
            if (inst.length == 0) continue;
            try {
                RenameAttribute rename = new RenameAttribute();
                rename.setAttributeIndices("last");
                rename.setFind("Classification." + index);
                rename.setReplace("Classification");
                rename.setInputFormat(inst[0].dataset());
                for (Instance in : inst) {
                    rename.input(in);
                }
                rename.batchFinished();
                for (int i = 0; i < inst.length; ++i) {
                    inst[i] = rename.output();
                }
                result.addAll(Arrays.asList(inst));
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to rename classification attribute: ");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        return result.toArray(new Instance[result.size()]);
    }
}

