/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.image.AbstractImage;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import weka.core.Instance;

public abstract class AbstractImageJFlattenerTestCase
extends AdamsTestCase {
    public AbstractImageJFlattenerTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/imagej/flattener/data");
    }

    protected ImagePlusContainer load(String filename) {
        String fullName = this.m_TestHelper.getTmpDirectory() + File.separator + filename;
        this.m_TestHelper.copyResourceToTmp(filename);
        ImagePlus img = IJ.openImage((String)fullName);
        ImagePlusContainer result = new ImagePlusContainer();
        result.setImage((Object)img);
        result.getReport().setStringValue("Filename", fullName);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected Instance[] process(ImagePlusContainer img, AbstractImageJFlattener scheme) {
        return scheme.flatten((AbstractImage)img);
    }

    protected boolean save(Instance[] data, String filename) {
        boolean result = true;
        for (Instance inst : data) {
            result = FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)inst.toString(), (boolean)false);
            if (!result) break;
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractImageJFlattener[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
        }
        result = result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractImageJFlattener[] setups = this.getRegressionSetups();
        AbstractImageJFlattenerTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            ImagePlusContainer data = this.load(input[i]);
            AbstractImageJFlattenerTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            Instance[] processed = this.process(data, setups[i]);
            AbstractImageJFlattenerTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractImageJFlattenerTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractImageJFlattenerTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

