/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ImagePlusContainer.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.data.imagej;

import java.awt.image.BufferedImage;

import ij.ImagePlus;
import adams.data.image.AbstractImage;

/**
 * Image wrapper around an ImagePlus used by ImageJ.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4753 $
 */
public class ImagePlusContainer
  extends AbstractImage<ImagePlus> {

  /**
   * Returns the width of the image.
   * 
   * @return		the width
   */
  public int getWidth() {
    if (m_Image == null)
      return 0;
    else
      return m_Image.getWidth();
  }

  /**
   * Returns the height of the image.
   * 
   * @return		the height
   */
  public int getHeight() {
    if (m_Image == null)
      return 0;
    else
      return m_Image.getHeight();
  }

  /**
   * Returns a clone of the image.
   * 
   * @return		the clone
   */
  protected ImagePlus cloneImage() {
    return new ImagePlus(m_Image.getTitle() + "'", m_Image.getImage());
  }

  /**
   * Turns the image into a buffered image.
   * 
   * @return		the buffered image
   */
  public BufferedImage toBufferedImage() {
    return m_Image.getBufferedImage();
  }
}
