/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.ImageJWriter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.ImageJReader;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ImageJReaderTest
extends AbstractFlowTest {
    public ImageJReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_logo.jpg");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_logo.jpg");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("adams_logo.png"));
        ImageJReader ir = new ImageJReader();
        ImageJWriter iw = new ImageJWriter();
        iw.setImageType(ImageJWriter.ImageType.AUTO);
        iw.setOutputFile((PlaceholderFile)new TmpFile("adams_logo.jpg"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, ir, iw});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(ImageJReaderTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ImageJReaderTest.runTest((Test)ImageJReaderTest.suite());
    }
}

