/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.core.BufferedImageHelper;
import adams.data.jai.BufferedImageContainer;
import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Pixels
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -8349656592325229512L;
    protected boolean m_SeparateRGB;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separate-rgb", "separateRGB", (Object)false);
    }

    public void setSeparateRGB(boolean value) {
        this.m_SeparateRGB = value;
        this.reset();
    }

    public boolean getSeparateRGB() {
        return this.m_SeparateRGB;
    }

    public String separateRGBTipText() {
        return "Whether to output the RGB values as separate attributes or a single combined one.";
    }

    @Override
    public Instances createHeader(BufferedImageContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < numPixels; ++i) {
            if (this.m_SeparateRGB) {
                atts.add(new Attribute("att_r_" + (i + 1)));
                atts.add(new Attribute("att_g_" + (i + 1)));
                atts.add(new Attribute("att_b_" + (i + 1)));
                continue;
            }
            atts.add(new Attribute("att_" + (i + 1)));
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(BufferedImageContainer img) {
        Instance[] result = null;
        double[] values = this.newArray(this.m_Header.numAttributes());
        if (this.m_SeparateRGB) {
            int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)img.getImage());
            for (int i = 0; i < rgbas.length; ++i) {
                values[i * 3 + 0] = rgbas[i][0];
                values[i * 3 + 1] = rgbas[i][1];
                values[i * 3 + 2] = rgbas[i][2];
            }
        } else {
            int[] pixels = BufferedImageHelper.getPixels((BufferedImage)img.getImage());
            for (int i = 0; i < pixels.length; ++i) {
                values[i] = pixels[i];
            }
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }
}

