/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class BufferedImageHelper {
    public static BufferedImage deepCopy(BufferedImage img) {
        ColorModel cm = img.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = img.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static int[] getPixels(BufferedImage img) {
        int[] result = new int[img.getWidth() * img.getHeight()];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[i] = img.getRGB(x, y);
                ++i;
            }
        }
        return result;
    }

    public static int[][] getRGBPixels(BufferedImage img) {
        int[][] result = new int[img.getWidth() * img.getHeight()][4];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int pixel = img.getRGB(x, y);
                result[i][0] = pixel & 0xFF;
                result[i][1] = pixel >> 8 & 0xFF;
                result[i][2] = pixel >> 16 & 0xFF;
                result[i][3] = pixel >> 24 & 0xFF;
                ++i;
            }
        }
        return result;
    }

    public static int[][] getPixelRaster(BufferedImage img) {
        int[][] result = new int[img.getHeight()][img.getWidth()];
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[y][x] = img.getRGB(x, y);
            }
        }
        return result;
    }
}

