/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import ij.ImagePlus;
import java.lang.reflect.Array;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Pixels
extends AbstractImageJFlattener {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public Instances createHeader(ImagePlusContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < numPixels; ++i) {
            atts.add(new Attribute("att_" + (i + 1)));
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(ImagePlusContainer img) {
        Instance[] result = null;
        Object pixels = ((ImagePlus)img.getImage()).getProcessor().getPixels();
        double[] values = this.newArray(this.m_Header.numAttributes());
        for (int i = 0; i < Array.getLength(pixels); ++i) {
            values[i] = Array.getDouble(pixels, i);
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }
}

