/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ImageJHelper;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import adams.data.imagej.flattener.Pixels;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import weka.core.Instance;

public class ImageJFlattener
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 2931644921913892736L;
    public static final String BACKUP_QUEUE = "queue";
    protected AbstractImageJFlattener m_FlattenAlgorithm;
    protected ArrayList<Instance> m_Queue;

    public String globalInfo() {
        return "Applies an ImageJ flattener to the incoming image and outputs the generated WEKA Instance(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("flattener", "flattenAlgorithm", (Object)new Pixels());
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    public void setFlattenAlgorithm(AbstractImageJFlattener value) {
        this.m_FlattenAlgorithm = value;
        this.reset();
    }

    public AbstractImageJFlattener getFlattenAlgorithm() {
        return this.m_FlattenAlgorithm;
    }

    public String flattenAlgorithmTipText() {
        return "The flattener to use for flattening the image.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("flattenAlgorithm");
        if (variable != null) {
            return variable;
        }
        if (this.m_FlattenAlgorithm != null) {
            return this.m_FlattenAlgorithm.getClass().getName();
        }
        return null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_QUEUE, this.m_Queue);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{ImagePlusContainer.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            ImageJHelper.setPluginsDirectory();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            this.m_Queue.addAll(Arrays.asList(this.m_FlattenAlgorithm.flatten((ImagePlusContainer)((Object)this.m_InputToken.getPayload()))));
        }
        catch (Exception e) {
            result = this.handleException("Failed to flatten data:", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Queue.get(0));
        this.m_Queue.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }
}

