/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.features;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.image.AbstractImageContainer;
import adams.data.jai.JAIHelper;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.image.ImageInt16;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.RenderedOp;

public abstract class AbstractBoofCVFeatureGeneratorTestCase
extends AdamsTestCase {
    public AbstractBoofCVFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/boofcv/features/data");
    }

    protected BoofCVImageContainer load(String filename) {
        BoofCVImageContainer result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        String fullName = this.m_TestHelper.getTmpDirectory() + File.separator + filename;
        RenderedOp op = JAIHelper.read((String)fullName);
        if (op != null) {
            result = new BoofCVImageContainer();
            result.setImage((Object)ConvertBufferedImage.convertFromSingle((BufferedImage)op.getAsBufferedImage(), null, ImageInt16.class));
            result.getReport().setStringValue("Filename", filename);
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected Object[] process(BoofCVImageContainer img, AbstractBoofCVFeatureGenerator scheme) {
        return scheme.generate((AbstractImageContainer)img);
    }

    protected String toString(Object obj) {
        if (obj instanceof Row) {
            Row row = (Row)obj;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < row.getCellCount(); ++i) {
                Cell cell;
                if (i > 0) {
                    result.append(",");
                }
                if ((cell = row.getCell(i)).isNumeric()) {
                    result.append(Utils.doubleToString((double)cell.toDouble(), (int)6));
                    continue;
                }
                result.append(cell.getContent());
            }
            return result.toString();
        }
        return obj.toString();
    }

    protected boolean save(Object[] data, String filename) {
        boolean result = true;
        for (Object obj : data) {
            result = FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)this.toString(obj), (boolean)false);
            if (!result) break;
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractBoofCVFeatureGenerator[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
        }
        result = result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractBoofCVFeatureGenerator[] setups = this.getRegressionSetups();
        AbstractBoofCVFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            BoofCVImageContainer data = this.load(input[i]);
            AbstractBoofCVFeatureGeneratorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            Object[] processed = this.process(data, setups[i]);
            AbstractBoofCVFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractBoofCVFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractBoofCVFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

