/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.imagej.features.Histogram;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ImageJFeatureGenerator;
import adams.flow.transformer.ImageJReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ImageJFeatureGeneratorTest
extends AbstractFlowTest {
    public ImageJFeatureGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier mfs = new FileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png"), new TmpFile("adams_icon.png")});
        ImageJReader ir = new ImageJReader();
        ImageJFeatureGenerator ifl = new ImageJFeatureGenerator();
        ifl.setAlgorithm((AbstractImageJFeatureGenerator)new Histogram());
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, ir, ifl, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(ImageJFeatureGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ImageJFeatureGeneratorTest.runTest((Test)ImageJFeatureGeneratorTest.suite());
    }
}

