/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.features;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageHelper;
import adams.data.report.DataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Pixels
extends AbstractBoofCVFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public HeaderDefinition createHeader(BoofCVImageContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < numPixels; ++i) {
            result.add("att_" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BoofCVImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        int height = img.getHeight();
        int width = img.getWidth();
        if (img.getImage() instanceof ImageInteger) {
            ImageInteger integer = (ImageInteger)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    result[0].add(integer.get(i, n));
                }
            }
        } else if (img.getImage() instanceof ImageFloat32) {
            ImageFloat32 float32 = (ImageFloat32)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    result[0].add(Float.valueOf(float32.get(i, n)));
                }
            }
        } else if (img.getImage() instanceof ImageFloat64) {
            ImageFloat64 float64 = (ImageFloat64)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    result[0].add(float64.get(i, n));
                }
            }
        } else if (img.getImage() instanceof ImageSInt64) {
            ImageSInt64 sInt64 = (ImageSInt64)img.getImage();
            for (int n = 0; n < height; ++n) {
                for (int i = 0; i < width; ++i) {
                    result[0].add(sInt64.get(i, n));
                }
            }
        } else {
            BufferedImage buff = img.toBufferedImage();
            int[] pixels = BufferedImageHelper.getPixels((BufferedImage)buff);
            for (int i = 0; i < pixels.length; ++i) {
                result[0].add(pixels[i]);
            }
        }
        return result;
    }
}

