/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.multiimageoperation;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.multiimageoperation.AbstractBoofCVMultiImageOperation;
import adams.data.image.AbstractImageContainer;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

public class And
extends AbstractBoofCVMultiImageOperation {
    public String globalInfo() {
        return "Performs a logical AND on the  binary pixels of the images.\nConverts images automatically to type " + (Object)((Object)BoofCVImageType.UNSIGNED_INT_8) + ".";
    }

    @Override
    public int numImagesRequired() {
        return 2;
    }

    protected void check(BoofCVImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        if (!this.checkSameDimensions(images[0], images[1])) {
            throw new IllegalStateException("Both images need to have the same dimensions: " + images[0].getWidth() + "x" + images[0].getHeight() + " != " + images[1].getWidth() + "x" + images[1].getHeight());
        }
    }

    protected BoofCVImageContainer[] doProcess(BoofCVImageContainer[] images) {
        BoofCVImageContainer[] result = new BoofCVImageContainer[1];
        ImageUInt8 img0 = (ImageUInt8)BoofCVHelper.toBoofCVImage(images[0], BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 img1 = (ImageUInt8)BoofCVHelper.toBoofCVImage(images[1], BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 output = (ImageUInt8)BoofCVHelper.clone((ImageBase)img0);
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int and = img0.get(x, y) == img1.get(x, y) ? 0 : 1;
                output.set(x, y, and);
            }
        }
        result[0] = new BoofCVImageContainer();
        result[0].setImage(output);
        return result;
    }
}

