/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.BufferedImageToOtherFormatConversion;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;

public class BufferedImageToBoofCV
extends AbstractConversion
implements BufferedImageToOtherFormatConversion {
    private static final long serialVersionUID = 267299130050379610L;
    protected BoofCVImageType m_ImageType;

    public String globalInfo() {
        return "Turns a BufferedImage container into a BoofCV one.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)BoofCVImageType.FLOAT_32);
    }

    public void setImageType(BoofCVImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public BoofCVImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The BoofCV image type to convert to.";
    }

    public Class accepts() {
        return BufferedImageContainer.class;
    }

    public Class generates() {
        return BoofCVImageContainer.class;
    }

    protected Object doConvert() throws Exception {
        return BoofCVHelper.toBoofCVImageContainer((AbstractImageContainer)this.m_Input, this.m_ImageType);
    }
}

