/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.barcode.decode.AbstractBarcodeDecoder;
import adams.data.barcode.decode.PassThrough;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.text.TextContainer;
import java.util.ArrayList;
import java.util.List;

public class Barcode
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected AbstractBarcodeDecoder m_Decoder;

    public String globalInfo() {
        return "Decodes any barcode in the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("decoder", "decoder", (Object)new PassThrough());
    }

    public void setDecoder(AbstractBarcodeDecoder value) {
        this.m_Decoder = value;
        this.reset();
    }

    public AbstractBarcodeDecoder getDecoder() {
        return this.m_Decoder;
    }

    public String decoderTipText() {
        return "The decoder algorithm to use.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Barcode", DataType.STRING);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        TextContainer cont = this.m_Decoder.decode((AbstractImageContainer)img);
        String barcode = null;
        if (cont != null && cont.getContent() != null && !((String)cont.getContent()).isEmpty()) {
            barcode = (String)cont.getContent();
        }
        List[] result = new List[]{new ArrayList()};
        result[0].add(barcode);
        return result;
    }
}

