/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.Channel;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import java.awt.image.BufferedImage;

public class CombineChannels
extends AbstractBufferedImageMultiImageOperation {
    private static final long serialVersionUID = 1888786897723421704L;
    protected Channel[] m_Channels;

    public String globalInfo() {
        return "Combines the channels into a single image. The channel images are expected to be gray scale images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("channel", "channels", (Object)new Channel[0]);
    }

    public void setChannels(Channel[] value) {
        this.m_Channels = value;
        this.reset();
    }

    public Channel[] getChannels() {
        return this.m_Channels;
    }

    public String channelsTipText() {
        return "The channels to get from the incoming image.";
    }

    @Override
    public int numImagesRequired() {
        return Math.max(this.m_Channels.length, 2);
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        for (int i = 1; i < this.m_Channels.length; ++i) {
            if (this.checkSameDimensions(images[0], images[i])) continue;
            throw new IllegalStateException("Images need to have the same dimensions (#1 vs #" + (i + 1) + "): " + images[0].getWidth() + "x" + images[0].getHeight() + " != " + images[i].getWidth() + "x" + images[i].getHeight());
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        int i;
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage newImg = new BufferedImage(images[0].getWidth(), images[0].getHeight(), 2);
        result[0] = (BufferedImageContainer)images[0].getHeader();
        result[0].setImage((Object)newImg);
        for (i = 0; i < images.length; ++i) {
            images[i].setImage((Object)BufferedImageHelper.convert((BufferedImage)((BufferedImage)images[i].getImage()), (int)10));
        }
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int[] pixels = new int[4];
                block9: for (i = 0; i < this.m_Channels.length; ++i) {
                    switch (this.m_Channels[i]) {
                        case RED: {
                            pixels[0] = ((BufferedImage)images[i].getImage()).getRGB(x, y);
                            continue block9;
                        }
                        case GREEN: {
                            pixels[1] = ((BufferedImage)images[i].getImage()).getRGB(x, y);
                            continue block9;
                        }
                        case BLUE: {
                            pixels[2] = ((BufferedImage)images[i].getImage()).getRGB(x, y);
                            continue block9;
                        }
                        case ALPHA: {
                            pixels[3] = ((BufferedImage)images[i].getImage()).getRGB(x, y);
                            continue block9;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled channel: " + (Object)((Object)this.m_Channels[i]));
                        }
                    }
                }
                ((BufferedImage)result[0].getImage()).setRGB(x, y, BufferedImageHelper.combine((int[])pixels));
            }
        }
        return result;
    }
}

