/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class XOr
extends AbstractBufferedImageMultiImageOperation {
    public String globalInfo() {
        return "Performs a logical XOR on the binary pixels of the images.\nConverts images automatically to type BufferedImage.TYPE_BYTE_BINARY.";
    }

    @Override
    public int numImagesRequired() {
        return 2;
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        if (!this.checkSameDimensions(images[0], images[1])) {
            throw new IllegalStateException("Both images need to have the same dimensions: " + images[0].getWidth() + "x" + images[0].getHeight() + " != " + images[1].getWidth() + "x" + images[1].getHeight());
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage img0 = BufferedImageHelper.convert((BufferedImage)((BufferedImage)images[0].getImage()), (int)12);
        BufferedImage img1 = BufferedImageHelper.convert((BufferedImage)((BufferedImage)images[1].getImage()), (int)12);
        BufferedImage output = BufferedImageHelper.deepCopy((BufferedImage)img0);
        int match = Color.BLACK.getRGB();
        int mismatch = Color.WHITE.getRGB();
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int xor = (img0.getRGB(x, y) == match || img1.getRGB(x, y) == match) && img0.getRGB(x, y) != img1.getRGB(x, y) ? match : mismatch;
                output.setRGB(x, y, xor);
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)output);
        return result;
    }
}

