/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.whitebalance.AbstractWhiteBalanceAlgorithm;
import adams.data.image.transformer.whitebalance.NoBalance;
import java.awt.image.BufferedImage;

public class WhiteBalance
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected AbstractWhiteBalanceAlgorithm m_Algorithm;

    public String globalInfo() {
        return "Processes the images passing through using the specified white balance algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new NoBalance());
    }

    public void setAlgorithm(AbstractWhiteBalanceAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractWhiteBalanceAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The white balance algorithm to apply to the image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)((Object)this.m_Algorithm));
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer result = (BufferedImageContainer)img.getHeader();
        result.setImage((Object)this.m_Algorithm.balance((BufferedImage)img.getImage()));
        return new BufferedImageContainer[]{result};
    }
}

