/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.crop;

import adams.core.Utils;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import adams.data.statistics.StatUtils;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ThresholdedCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;
    protected double m_NoiseLevel;

    public String globalInfo() {
        return "Simple cropping algorithm that assumes a good contrast between background and foreground.\nAlgorithm:\n- create histogram of grayscale image\n- remove counts from histogram that fall below noise-level\n- determine left-most (L) and right-most (R) non-zero count\n- divide region between L and R into two and determine highest peak in each (LP and RP)\n- 8-bit threshold is halfway between LP and RP\n- determine first pixel that is above threshold from top, bottom, left and right, which is used for the crop";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("noise-level", "noiseLevel", (Object)0.05, (Number)0.0, (Number)1.0);
    }

    public void setNoiseLevel(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_NoiseLevel = value;
            this.reset();
        } else {
            this.getLogger().warning("Noise level must satisfy 0 <= x <= 1, provided: " + value);
        }
    }

    public double getNoiseLevel() {
        return this.m_NoiseLevel;
    }

    public String noiseLevelTipText() {
        return "The noise level in percent (0-1).";
    }

    protected int findThreshold(BufferedImage img) {
        int i;
        int[][] histo = BufferedImageHelper.histogram((BufferedImage)img, (boolean)true);
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("Histogram: " + Utils.arrayToString((Object)histo[0]));
        }
        int max = StatUtils.max((int[])histo[0]);
        double noise = (double)max * this.m_NoiseLevel;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Noise level at " + this.m_NoiseLevel + ": " + noise);
        }
        for (i = 0; i < histo[0].length; ++i) {
            if (!((double)histo[0][i] < noise)) continue;
            histo[0][i] = 0;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("Denoised histogram: " + Utils.arrayToString((Object)histo[0]));
        }
        int left = 0;
        for (i = 0; i < histo[0].length; ++i) {
            if (histo[0][i] <= 0) continue;
            left = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("left non-zero: " + left);
        }
        int right = 255;
        for (i = histo[0].length - 1; i >= 0; --i) {
            if (histo[0][i] <= 0) continue;
            right = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("right non-zero: " + right);
        }
        int[] subset = new int[(right - left + 1) / 2];
        System.arraycopy(histo[0], left, subset, 0, subset.length);
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("left subset: " + Utils.arrayToString((Object)subset));
        }
        int leftPeak = left + StatUtils.maxIndex((int[])subset);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("left peak: " + leftPeak);
        }
        subset = new int[(right - left + 1) / 2];
        System.arraycopy(histo[0], right - subset.length + 1, subset, 0, subset.length);
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("right subset: " + Utils.arrayToString((Object)subset));
        }
        int rightPeak = right - subset.length + 1 + StatUtils.maxIndex((int[])subset);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("right peak: " + rightPeak);
        }
        int result = rightPeak - leftPeak + 1;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("threshold: " + result);
        }
        return result;
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int i;
        BufferedImage gray = BufferedImageHelper.convert((BufferedImage)img, (int)10);
        int threshold = this.findThreshold(gray);
        int width = img.getWidth();
        int height = img.getHeight();
        int xMiddle = width / 2;
        int yMiddle = height / 2;
        int top = 0;
        for (i = 0; i < yMiddle; ++i) {
            if ((gray.getRGB(xMiddle, i) >> 0 & 0xFF) <= threshold) continue;
            top = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("top: " + top);
        }
        int bottom = height - 1;
        for (i = height - 1; i >= yMiddle; --i) {
            if ((gray.getRGB(xMiddle, i) >> 0 & 0xFF) <= threshold) continue;
            bottom = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("bottom: " + bottom);
        }
        int left = 0;
        for (i = 0; i < xMiddle; ++i) {
            if ((gray.getRGB(i, yMiddle) >> 0 & 0xFF) <= threshold) continue;
            left = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("left: " + left);
        }
        int right = width - 1;
        for (i = width - 1; i >= xMiddle; --i) {
            if ((gray.getRGB(i, yMiddle) >> 0 & 0xFF) <= threshold) continue;
            right = i;
            break;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("right: " + right);
        }
        this.m_TopLeft = new Point(left, top);
        this.m_BottomRight = new Point(right, bottom);
        BufferedImage image = img.getSubimage(left, top, right - left + 1, bottom - top + 1);
        return image;
    }
}

