/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagefilter;

import adams.core.base.BaseColor;
import adams.data.imagefilter.AbstractImageFilterProvider;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;

public class KeepOnlyColors
extends AbstractImageFilterProvider {
    private static final long serialVersionUID = -151175675073048859L;
    protected BaseColor[] m_Colors;
    protected Color m_Replacement;

    public String globalInfo() {
        return "Keeps only the specified colors and turns all other pixels to transparent.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "colors", (Object)new BaseColor[0]);
        this.m_OptionManager.add("replacement", "replacement", (Object)Color.WHITE);
    }

    public void setColors(BaseColor[] value) {
        this.m_Colors = value;
        this.reset();
    }

    public BaseColor[] getColors() {
        return this.m_Colors;
    }

    public String colorsTipText() {
        return "The colors to keep.";
    }

    public void setReplacement(Color value) {
        this.m_Replacement = value;
        this.reset();
    }

    public Color getReplacement() {
        return this.m_Replacement;
    }

    public String replacementTipText() {
        return "The color to replace the unwanted colors with.";
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_Colors == null || this.m_Colors.length == 0) {
            throw new IllegalStateException("No colors provided that should be kept!");
        }
    }

    @Override
    protected ImageFilter doGenerate(BufferedImage img) {
        final int[] markers = new int[this.m_Colors.length];
        for (int i = 0; i < this.m_Colors.length; ++i) {
            markers[i] = this.m_Colors[i].toColorValue().getRGB();
        }
        final int replacement = this.m_Replacement.getRGB();
        return new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                for (int i = 0; i < markers.length; ++i) {
                    if (rgb != markers[i]) continue;
                    return rgb;
                }
                return replacement;
            }
        };
    }
}

