/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagefilter;

import adams.core.Index;
import adams.data.imagefilter.AbstractImageFilterProvider;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;

public class TransparentBackground
extends AbstractImageFilterProvider {
    private static final long serialVersionUID = -151175675073048859L;
    protected Index m_X;
    protected Index m_Y;

    public String globalInfo() {
        return "Uses the color at the specified location as background and turns it transparent.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)new Index("1"));
        this.m_OptionManager.add("y", "Y", (Object)new Index("1"));
    }

    public void setX(Index value) {
        this.m_X = value;
        this.reset();
    }

    public Index getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the pixel to get the color of the background from.";
    }

    public void setY(Index value) {
        this.m_Y = value;
        this.reset();
    }

    public Index getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the pixel to get the color of the background from.";
    }

    @Override
    protected ImageFilter doGenerate(BufferedImage img) {
        this.m_X.setMax(img.getWidth());
        this.m_Y.setMax(img.getHeight());
        final int marker = img.getRGB(this.m_X.getIntIndex(), this.m_Y.getIntIndex()) | 0xFFFFFFFF;
        return new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == marker) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
    }
}

