/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.report.DataType;
import ij.ImagePlus;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Pixels
extends AbstractImageJFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public HeaderDefinition createHeader(ImagePlusContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        int numPixels = img.getWidth() * img.getHeight();
        for (int i = 0; i < numPixels; ++i) {
            result.add("att_" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(ImagePlusContainer img) {
        List[] result = null;
        Object pixels = ((ImagePlus)img.getImage()).getProcessor().getPixels();
        result = new List[]{new ArrayList()};
        for (int i = 0; i < Array.getLength(pixels); ++i) {
            result[0].add(Array.getDouble(pixels, i));
        }
        return result;
    }
}

