/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick.im;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.imagemagick.im.AbstractIMSimpleOperation;
import org.im4java.core.IMOperation;

public class AdaptiveResize
extends AbstractIMSimpleOperation {
    private static final long serialVersionUID = 3529048936510645338L;
    public static final String GEOMETRY_CHARS = "<>!@%";
    protected int m_Width;
    protected int m_Height;
    protected String m_Geometry;

    public String globalInfo() {
        return "Adaptive resize (option -adaptive-resize)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("geometry", "geometry", (Object)"");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)"width: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", height: ");
        return result;
    }

    public void setWidth(int value) {
        if (value == -1 || value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().warning("Width must be -1 or >0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width in pixels; -1 for current width.";
    }

    public void setHeight(int value) {
        if (value == -1 || value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().warning("Height must be -1 or >0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height in pixels; -1 for current height.";
    }

    public void setGeometry(String value) {
        if ((value = value.trim()).length() == 0 || value.length() == 1 && GEOMETRY_CHARS.indexOf(value.charAt(0)) > -1) {
            this.m_Geometry = value;
            this.reset();
        } else {
            this.getLogger().warning("Geometry specfication must be empty or one of the following characters: <>!@%");
        }
    }

    public String getGeometry() {
        return this.m_Geometry;
    }

    public String geometryTipText() {
        return "The geometry specification character, empty or one of the following characters: <>!@%";
    }

    @Override
    protected void addOperation(IMOperation op) {
        if (this.m_Height == -1) {
            if (this.m_Width == -1) {
                op.adaptiveResize();
            } else {
                op.adaptiveResize(Integer.valueOf(this.m_Width));
            }
        } else if (this.m_Geometry.length() == 0) {
            op.adaptiveResize(Integer.valueOf(this.m_Width), Integer.valueOf(this.m_Height));
        } else {
            op.adaptiveResize(Integer.valueOf(this.m_Width), Integer.valueOf(this.m_Height), this.m_Geometry);
        }
    }
}

