/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick.ufraw;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.data.imagemagick.ufraw.AbstractUfrawOperation;
import org.im4java.core.Operation;
import org.im4java.core.UFRawCmd;
import org.im4java.core.UFRawOperation;

public abstract class AbstractUfrawSimpleOperation
extends AbstractUfrawOperation {
    private static final long serialVersionUID = 4447009209054143230L;

    protected abstract void addOperation(UFRawOperation var1);

    protected void addOutType(UFRawOperation op, PlaceholderFile output) {
        String ext = FileUtils.getExtension((String)output.getAbsolutePath()).toLowerCase();
        String out = "ppm";
        for (String ot : OUT_TYPES) {
            if (!ext.equals(ot)) continue;
            out = ot;
            break;
        }
        op.outType(out);
    }

    @Override
    protected String doApply(PlaceholderFile input, PlaceholderFile output) {
        String result = null;
        if (result == null) {
            try {
                UFRawCmd cmd = new UFRawCmd(true);
                UFRawOperation op = new UFRawOperation();
                op.overwrite();
                op.addImage(new String[]{input.getAbsolutePath()});
                this.addOperation(op);
                op.output(output.getAbsolutePath());
                this.addOutType(op, output);
                cmd.run((Operation)op, new Object[0]);
            }
            catch (Exception e) {
                result = Utils.handleException((LoggingObject)this, (String)"Failed to apply operation!", (Throwable)e);
            }
        }
        return result;
    }
}

