/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.BoofCVImageWriter;
import boofcv.io.image.UtilImageIO;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;

public class BoofCVImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = 5347100846354068540L;
    protected String[] m_FormatExtensions;

    public String globalInfo() {
        return "BoofCV image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\n" + "For more information see:\n" + "http://boofcv.org/";
    }

    protected void initialize() {
        super.initialize();
        ArrayList<String> formats = new ArrayList<String>();
        formats.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        if (!formats.contains("ppm")) {
            formats.add("ppm");
        }
        if (!formats.contains("pgm")) {
            formats.add("pgm");
        }
        Collections.sort(formats);
        this.m_FormatExtensions = formats.toArray(new String[formats.size()]);
    }

    public String getFormatDescription() {
        return "BoofCV";
    }

    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return new BoofCVImageWriter();
    }

    protected BufferedImageContainer doRead(PlaceholderFile file) {
        BufferedImageContainer result = null;
        BufferedImage image = UtilImageIO.loadImage((String)file.getAbsolutePath());
        if (image != null) {
            result = new BufferedImageContainer();
            result.setImage((Object)image);
        }
        return result;
    }
}

