/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.imagemagick.ImageMagickHelper;
import adams.data.imagemagick.ImageType;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.ImageMagickImageReader;
import adams.data.io.output.AbstractImageWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class ImageMagickImageWriter
extends AbstractImageWriter<BufferedImageContainer> {
    private static final long serialVersionUID = 6385191315392140321L;
    protected ImageType m_ImageType;

    public String globalInfo() {
        return "ImageMagick image writer for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\n" + "For more information see:\n" + "http://www.imagemagick.org/\n" + (ImageMagickHelper.isConvertAvailable() ? "" : "\n" + ImageMagickHelper.getMissingConvertErrorMessage());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)ImageType.AUTO);
    }

    public String getFormatDescription() {
        return "ImageMagick image writer";
    }

    public String[] getFormatExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (ImageType it : ImageType.values()) {
            if (it == ImageType.AUTO || !it.canWrite()) continue;
            result.add(it.getExtension());
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public boolean isAvailable() {
        return ImageMagickHelper.isConvertAvailable();
    }

    public void setImageType(ImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public ImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The type of image to create.";
    }

    public AbstractImageReader getCorrespondingReader() {
        return new ImageMagickImageReader();
    }

    protected void check(BufferedImageContainer cont) {
        super.check((AbstractImageContainer)cont);
        if (!ImageMagickHelper.isConvertAvailable()) {
            throw new IllegalStateException(ImageMagickHelper.getMissingConvertErrorMessage());
        }
    }

    protected ImageType determineImageType(String filename) {
        ImageType result = null;
        for (ImageType type : ImageType.values()) {
            if (!type.matches(filename)) continue;
            result = type;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Failed to determine image type for '" + filename + "'!");
        }
        return result;
    }

    protected String doWrite(PlaceholderFile file, BufferedImageContainer cont) {
        String result = null;
        try {
            ImageType type = this.m_ImageType == ImageType.AUTO ? this.determineImageType(file.getAbsolutePath()) : this.m_ImageType;
            IMOperation op = new IMOperation();
            op.addImage();
            op.addImage(new String[]{type.getType() + ":" + file.getAbsolutePath()});
            ConvertCmd cmd = new ConvertCmd();
            cmd.run((Operation)op, new Object[]{cont.toBufferedImage()});
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingObject)this, (String)("Failed to write image to: " + file), (Throwable)e);
        }
        return result;
    }
}

