/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.annotation.DeprecatedClass;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.imagemagick.ImageMagickHelper;
import adams.data.imagemagick.ImageType;
import adams.data.io.output.ImageMagickImageWriter;
import adams.flow.sink.AbstractFileWriter;
import adams.flow.sink.ImageWriter;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

@Deprecated
@DeprecatedClass(useInstead={ImageWriter.class, ImageMagickImageWriter.class})
public class ImageMagickWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -1264554670448330464L;
    protected ImageType m_ImageType;

    public String globalInfo() {
        return "Writes an image to disk using ImageMagick (http://www.imagemagick.org/).\n\nDEPRECATED\nUse " + ImageWriter.class.getName() + " in conjunction with the " + ImageMagickImageWriter.class.getName() + " instead.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)ImageType.AUTO);
    }

    public String getQuickInfo() {
        return super.getQuickInfo() + QuickInfoHelper.toString((OptionHandler)this, (String)"imageType", (Object)((Object)this.m_ImageType), (String)", image type: ");
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setImageType(ImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public ImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The type of image to create.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !ImageMagickHelper.isConvertAvailable()) {
            result = ImageMagickHelper.getMissingConvertErrorMessage();
        }
        return result;
    }

    protected ImageType determineImageType(String filename) {
        ImageType result = null;
        for (ImageType type : ImageType.values()) {
            if (!type.matches(filename)) continue;
            result = type;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Failed to determine image type for '" + filename + "'!");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer img = (AbstractImageContainer)this.m_InputToken.getPayload();
        String filename = this.m_OutputFile.getAbsolutePath();
        try {
            ImageType type = this.m_ImageType == ImageType.AUTO ? this.determineImageType(filename) : this.m_ImageType;
            IMOperation op = new IMOperation();
            op.addImage();
            op.addImage(new String[]{type.getType() + ":" + filename});
            ConvertCmd cmd = new ConvertCmd();
            cmd.run((Operation)op, new Object[]{img.toBufferedImage()});
        }
        catch (Exception e) {
            result = this.handleException("Failed to write image to: " + this.m_OutputFile, e);
        }
        return result;
    }
}

