/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import adams.data.image.multiimageoperation.PassThrough;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class BufferedImageMultiImageOperation
extends AbstractArrayProvider
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String BACKUP_CURRENTIMAGES = "current images";
    protected AbstractBufferedImageMultiImageOperation m_Operation;
    protected List<BufferedImageContainer> m_CurrentImages;

    public String globalInfo() {
        return "Applies a BufferedImage multi-image operation to the incoming image(s) and outputs the generated image(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new PassThrough());
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImages = new ArrayList<BufferedImageContainer>();
    }

    public String outputArrayTipText() {
        return "Whether to output the generated images as array or one-by-one.";
    }

    public void setOperation(AbstractBufferedImageMultiImageOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractBufferedImageMultiImageOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to apply to the images.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer[].class};
    }

    protected Class getItemClass() {
        return BufferedImageContainer.class;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTIMAGES);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_CURRENTIMAGES, this.m_CurrentImages);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTIMAGES)) {
            this.m_CurrentImages = (List)state.get(BACKUP_CURRENTIMAGES);
            state.remove(BACKUP_CURRENTIMAGES);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractImageContainer[] input = (AbstractImageContainer[])this.m_InputToken.getPayload();
            BufferedImageContainer[] img = new BufferedImageContainer[input.length];
            for (int i = 0; i < input.length; ++i) {
                img[i] = BufferedImageHelper.toBufferedImageContainer((AbstractImageContainer)input[i]);
            }
            this.m_CurrentImages = new ArrayList<AbstractImageContainer>(Arrays.asList(this.m_Operation.process((AbstractImageContainer[])img)));
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform image(s): ", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_CurrentImages.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_CurrentImages.get(0));
        this.m_CurrentImages.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void wrapUp() {
        this.m_CurrentImages.clear();
        super.wrapUp();
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

