/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImageJHelper;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.imagej.features.Pixels;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class ImageJFeatureGenerator
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 2931644921913892736L;
    public static final String BACKUP_QUEUE = "queue";
    protected AbstractImageJFeatureGenerator m_Algorithm;
    protected ArrayList m_Queue;

    public String globalInfo() {
        return "Applies an ImageJ feature generator to the incoming image and outputs the generated features.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new Pixels());
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    public void setAlgorithm(AbstractImageJFeatureGenerator value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractImageJFeatureGenerator getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The feature generation algorithm to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm);
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_QUEUE, this.m_Queue);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        if (this.m_Algorithm == null) {
            return new Class[]{Object.class};
        }
        return new Class[]{this.m_Algorithm.getRowFormat()};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            ImageJHelper.setPluginsDirectory();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            ImagePlusContainer cont = ImageJHelper.toImagePlusContainer((AbstractImageContainer)this.m_InputToken.getPayload());
            this.m_Queue.addAll(Arrays.asList(this.m_Algorithm.generate(cont)));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate features:", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }
}

