/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.imagej.ImageJHelper;
import adams.data.imagej.ImagePlusContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;

public class ImageJReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 275040379368744L;

    public String globalInfo() {
        return "Reads any file format that ImageJ can read.\nWARNING: may not close files properly.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{ImagePlusContainer.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            ImageJHelper.setPluginsDirectory();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : (File)this.m_InputToken.getPayload();
        try {
            ImagePlus img = IJ.openImage((String)file.getAbsolutePath());
            ImagePlusContainer cont = new ImagePlusContainer();
            cont.setImage(img);
            cont.getReport().setStringValue("Filename", file.getAbsolutePath());
            cont.getReport().setStringValue("Path", file.getParentFile().getAbsolutePath());
            cont.getReport().setStringValue("Name", file.getName());
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to read image: " + file, e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

