/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.imagepreparation;

import adams.core.Stoppable;
import adams.core.option.AbstractOptionHandler;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractImagePreparation
extends AbstractOptionHandler
implements Stoppable {
    private static final long serialVersionUID = -4035633099365011707L;
    protected List<String> m_Errors;
    protected List<String> m_Warnings;
    protected boolean m_Stopped;

    protected void initialize() {
        super.initialize();
        this.m_Errors = new ArrayList<String>();
        this.m_Warnings = new ArrayList<String>();
    }

    protected void reset() {
        super.reset();
        this.m_Errors.clear();
        this.m_Warnings.clear();
    }

    public boolean hasErrors() {
        return this.m_Errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.m_Errors;
    }

    protected void addError(String msg) {
        this.m_Errors.add(msg);
    }

    public boolean hasWarnings() {
        return this.m_Warnings.size() > 0;
    }

    public List<String> getWarnings() {
        return this.m_Warnings;
    }

    protected void addWarning(String msg) {
        this.m_Warnings.add(msg);
    }

    protected void check(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("No image provided!");
        }
    }

    protected abstract BufferedImage doProcess(BufferedImage var1);

    public BufferedImage process(BufferedImage image) {
        this.m_Stopped = false;
        this.m_Errors.clear();
        this.m_Warnings.clear();
        this.check(image);
        BufferedImage result = this.doProcess(image);
        if (this.m_Stopped) {
            result = image;
        }
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }
}

