/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.option.OptionHandler;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_I32;
import java.awt.image.BufferedImage;
import java.util.List;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="https://github.com/lessthanoptimal/BoofCV/blob/v0.15/examples/src/boofcv/examples/ExampleFitPolygon.java", note="Code taken from this BoofCV example")
public class CannyEdges
extends AbstractObjectLocator {
    private static final long serialVersionUID = 9160763275489359825L;
    protected int m_BlurRadius;
    protected float m_ThresholdLow;
    protected float m_ThresholdHigh;

    public String globalInfo() {
        return "Uses the BoofCV canny edges algorithm to locate objects.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("blur-radius", "blurRadius", (Object)2, (Number)0, null);
        this.m_OptionManager.add("threshold-low", "thresholdLow", (Object)Float.valueOf(0.1f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("threshold-high", "thresholdHigh", (Object)Float.valueOf(0.3f), (Number)Float.valueOf(0.0f), null);
    }

    public void setBlurRadius(int value) {
        if (value >= 0) {
            this.m_BlurRadius = value;
            this.reset();
        } else {
            this.getLogger().warning("Blur radius must be at least 0, provided: " + value);
        }
    }

    public int getBlurRadius() {
        return this.m_BlurRadius;
    }

    public String blurRadiusTipText() {
        return "The blur radius.";
    }

    public void setThresholdLow(float value) {
        if (value >= 0.0f) {
            this.m_ThresholdLow = value;
            this.reset();
        } else {
            this.getLogger().warning("Low threshold must be at least 0, provided: " + value);
        }
    }

    public float getThresholdLow() {
        return this.m_ThresholdLow;
    }

    public String thresholdLowTipText() {
        return "The low threshold.";
    }

    public void setThresholdHigh(float value) {
        if (value >= 0.0f) {
            this.m_ThresholdHigh = value;
            this.reset();
        } else {
            this.getLogger().warning("High threshold must be at least 0, provided: " + value);
        }
    }

    public float getThresholdHigh() {
        return this.m_ThresholdHigh;
    }

    public String thresholdHighTipText() {
        return "The high threshold.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"blurRadius", (Object)this.m_BlurRadius, (String)"radius: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"thresholdLow", (Object)Float.valueOf(this.m_ThresholdLow), (String)", low: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"thresholdHigh", (Object)Float.valueOf(this.m_ThresholdHigh), (String)", high: ");
        return result;
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        ImageFloat32 input = (ImageFloat32)ConvertBufferedImage.convertFromSingle((BufferedImage)image, null, ImageFloat32.class);
        CannyEdge canny = FactoryEdgeDetectors.canny((int)this.m_BlurRadius, (boolean)true, (boolean)true, ImageFloat32.class, ImageFloat32.class);
        canny.process((ImageSingleBand)input, this.m_ThresholdLow, this.m_ThresholdHigh, null);
        List contours = canny.getContours();
        LocatedObjects result = new LocatedObjects();
        for (EdgeContour contour : contours) {
            int left = image.getWidth();
            int right = 0;
            int top = image.getHeight();
            int bottom = 0;
            for (EdgeSegment seg : contour.segments) {
                for (Point2D_I32 p : seg.points) {
                    if (left > p.getX()) {
                        left = p.getX();
                    }
                    if (right < p.getX()) {
                        right = p.getX();
                    }
                    if (top > p.getY()) {
                        top = p.getY();
                    }
                    if (bottom >= p.getY()) continue;
                    bottom = p.getY();
                }
            }
            result.add(new LocatedObject(annotateOnly ? null : image.getSubimage(left, top, right - left + 1, bottom - top + 1), left, top, right - left + 1, bottom - top + 1));
        }
        return result;
    }
}

