/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.clipboard;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.gui.clipboard.AbstractClipboardData;
import adams.gui.core.GUIHelper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;

public class BufferedImage
extends AbstractClipboardData<java.awt.image.BufferedImage> {
    private static final long serialVersionUID = 3264721542935946632L;

    public String globalInfo() {
        return "Copies/pastes (buffered) images.";
    }

    public Class getFlowClass() {
        return BufferedImageContainer.class;
    }

    public void copy(java.awt.image.BufferedImage data) {
        GUIHelper.copyToClipboard((java.awt.image.BufferedImage)data);
    }

    protected java.awt.image.BufferedImage unwrap(Token data) {
        if (data.getPayload() instanceof java.awt.image.BufferedImage) {
            return (java.awt.image.BufferedImage)data.getPayload();
        }
        if (data.getPayload() instanceof AbstractImageContainer) {
            return ((AbstractImageContainer)data.getPayload()).toBufferedImage();
        }
        return null;
    }

    public boolean canPaste() {
        return GUIHelper.canPasteFromClipboard((DataFlavor)DataFlavor.imageFlavor);
    }

    protected Token wrap(java.awt.image.BufferedImage data) {
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)data);
        return new Token((Object)data);
    }

    @MixedCopyright(author="ImageJ", license=License.PUBLIC_DOMAIN, url="http://rsbweb.nih.gov/ij/developer/source/ij/plugin/Clipboard.java.html", note="taken from showSystemClipboard() method")
    public java.awt.image.BufferedImage paste() {
        java.awt.image.BufferedImage result = null;
        Image img = (Image)GUIHelper.pasteFromClipboard((DataFlavor)DataFlavor.imageFlavor);
        if (img != null) {
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            result = new java.awt.image.BufferedImage(width, height, 1);
            Graphics2D g = result.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
        }
        return result;
    }
}

