/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.BoofCVDetectLineSegments;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class BoofCVDetectLineSegmentsImageOverlay
extends AbstractImageOverlay {
    private static final long serialVersionUID = -4190767869077702132L;
    protected Color m_Color;
    protected SpreadSheet m_Lines;

    public String globalInfo() {
        return "Overlays the image with line segments detected by " + BoofCVDetectLineSegments.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the lines.";
    }

    public void setLines(SpreadSheet value) {
        this.m_Lines = value;
    }

    public SpreadSheet getLines() {
        return this.m_Lines;
    }

    protected void doImageChanged(ImagePanel.PaintPanel panel) {
    }

    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Lines == null) {
            return;
        }
        g.setColor(this.m_Color);
        Graphics2D g2 = (Graphics2D)g;
        for (Row row : this.m_Lines.rows()) {
            double ax = row.getCell(1).toDouble();
            double ay = row.getCell(2).toDouble();
            double bx = row.getCell(3).toDouble();
            double by = row.getCell(4).toDouble();
            g2.drawLine((int)ax, (int)ay, (int)bx, (int)by);
        }
    }
}

