/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.barcode.decode.AbstractBarcodeDecoder;
import adams.data.barcode.decode.ZXing;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.text.TextContainer;
import adams.gui.dialog.TextDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPluginWithGOE;
import org.apache.commons.lang.time.StopWatch;

public class Barcode
extends AbstractImageViewerPluginWithGOE {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "Barcode...";
    }

    public String getIconName() {
        return "barcode.gif";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String createLogEntry() {
        return OptionUtils.getCommandLine((Object)this.getLastSetup());
    }

    protected Class getEditorType() {
        return AbstractBarcodeDecoder.class;
    }

    protected Object getDefaultValue() {
        return new ZXing();
    }

    protected String process() {
        String result = null;
        try {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)((ImagePanel)this.m_CurrentPanel).getCurrentImage());
            StopWatch watch = new StopWatch();
            watch.start();
            AbstractBarcodeDecoder decoder = (AbstractBarcodeDecoder)((Object)this.getLastSetup());
            TextContainer text = decoder.decode((AbstractImageContainer)cont);
            watch.stop();
            TextDialog dialog = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new TextDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog()) : new TextDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame());
            if (((ImagePanel)this.m_CurrentPanel).getCurrentFile() != null) {
                dialog.setDialogTitle("Barcode - " + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getName() + " [" + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getParent() + "]");
            } else {
                dialog.setDialogTitle("Barcode");
            }
            dialog.setEditable(false);
            if (text != null) {
                dialog.setContent((String)text.getContent() + "\n\nTime (ms): " + watch.getTime() + "\n\nMeta-data\n\n" + text.getReport());
                dialog.setSize(400, 400);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            } else {
                result = "Failed to extract barcode! None present?";
            }
        }
        catch (Exception e) {
            result = "Failed to extract barcode: " + Utils.throwableToString((Throwable)e);
        }
        return result;
    }
}

