/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class Resize
extends AbstractJAITransformer {
    private static final long serialVersionUID = -7139209460998569352L;
    protected double m_Width;
    protected double m_Height;
    protected InterpolationType m_InterpolationType;
    protected int m_NumSubsampleBits;

    public String globalInfo() {
        return "Resizes the image to predefined width and height.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)-1.0, (Number)-1.0, null);
        this.m_OptionManager.add("height", "height", (Object)-1.0, (Number)-1.0, null);
        this.m_OptionManager.add("interpolation-type", "interpolationType", (Object)InterpolationType.BICUBIC);
        this.m_OptionManager.add("num-subsample-bits", "numSubsampleBits", (Object)8, (Number)1, null);
    }

    public void setWidth(double value) {
        if (value >= -1.0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width must be -1 (current width) or greater, provided: " + value);
        }
    }

    public double getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width to resize the image to; use -1 to use original width; use (0-1) for percentage.";
    }

    public void setHeight(double value) {
        if (value >= -1.0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height must be -1 (current height) or greater, provided: " + value);
        }
    }

    public double getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height to resize the image to; use -1 to use original height; use (0-1) for percentage.";
    }

    public void setInterpolationType(InterpolationType value) {
        this.m_InterpolationType = value;
        this.reset();
    }

    public InterpolationType getInterpolationType() {
        return this.m_InterpolationType;
    }

    public String interpolationTypeTipText() {
        return "The type of interpolation to perform.";
    }

    public void setNumSubsampleBits(int value) {
        if (value > 0) {
            this.m_NumSubsampleBits = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of subsample bits must be >0, provided: " + value);
        }
    }

    public int getNumSubsampleBits() {
        return this.m_NumSubsampleBits;
    }

    public String numSubsampleBitsTipText() {
        return "The number of bits to use for precision when subsampling.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage im = (BufferedImage)img.getImage();
        ParameterBlock params = new ParameterBlock();
        params.addSource(im);
        if (this.m_Width == -1.0) {
            params.add(1.0f);
        } else if (this.m_Width >= 0.0 && this.m_Width <= 1.0) {
            params.add((float)this.m_Width);
        } else {
            params.add((float)(this.m_Width / (double)img.getWidth()));
        }
        if (this.m_Height == -1.0) {
            params.add(1.0f);
        } else if (this.m_Height >= 0.0 && this.m_Height <= 1.0) {
            params.add((float)this.m_Height);
        } else {
            params.add((float)(this.m_Height / (double)img.getHeight()));
        }
        params.add(0.0f);
        params.add(0.0f);
        switch (this.m_InterpolationType) {
            case NEAREST: {
                params.add(new InterpolationNearest());
                break;
            }
            case BILINEAR: {
                params.add(new InterpolationBilinear(this.m_NumSubsampleBits));
                break;
            }
            case BICUBIC: {
                params.add(new InterpolationBicubic(this.m_NumSubsampleBits));
                break;
            }
            case BICUBIC2: {
                params.add(new InterpolationBicubic2(this.m_NumSubsampleBits));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled interpolation type: " + (Object)((Object)this.m_InterpolationType));
            }
        }
        RenderedOp imNew = JAI.create((String)"scale", (ParameterBlock)params);
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)imNew.getAsBufferedImage());
        return result;
    }

    public static enum InterpolationType {
        NEAREST,
        BILINEAR,
        BICUBIC,
        BICUBIC2;

    }
}

