/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

public enum TesseractPageSegmentation implements EnumWithCustomDisplay<TesseractPageSegmentation>
{
    OSD_ONLY(0, "Orientation and script detection (OSD) only"),
    AUTO_WITH_OSD(1, "Automatic page segmentation with OSD"),
    AUTO_NO_OSD(2, "Automatic page segmentation, but no OSD, or OCR"),
    FULL_AUTO_NO_OSD(3, "Fully automatic page segmentation, but no OSD"),
    SINGLE_COLUMN(4, "Assume a single column of text of variable sizes"),
    SINGLE_VERTICAL_BLOCK(5, "Assume a single uniform block of vertically aligned text"),
    SINGLE_BLOCK(6, "Assume a single uniform block of text"),
    SINGLE_LINE(7, "Treat the image as a single text line"),
    SINGLE_WORD(8, "Treat the image as a single word"),
    SINGLE_WORD_CIRCLE(9, "Treat the image as a single word in a circle"),
    SINGLE_CHARACTER(10, "Treat the image as a single character");

    private String m_Display;
    private Integer m_Code;
    private String m_Raw;

    private TesseractPageSegmentation(Integer code, String display) {
        this.m_Code = code;
        this.m_Display = display;
        this.m_Raw = super.toString();
    }

    public String toDisplay() {
        return this.m_Display;
    }

    public Integer toCode() {
        return this.m_Code;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public String toString() {
        return this.toDisplay();
    }

    public TesseractPageSegmentation parse(String s) {
        return TesseractPageSegmentation.valueOf((AbstractOption)null, s);
    }

    public static String toString(AbstractOption option, Object object) {
        return ((TesseractPageSegmentation)((Object)object)).toRaw();
    }

    public static TesseractPageSegmentation valueOf(AbstractOption option, String str) {
        TesseractPageSegmentation result = null;
        try {
            result = TesseractPageSegmentation.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (TesseractPageSegmentation seg : TesseractPageSegmentation.values()) {
                if (!seg.toDisplay().equals(str)) continue;
                result = seg;
                break;
            }
        }
        if (result == null) {
            for (TesseractPageSegmentation seg : TesseractPageSegmentation.values()) {
                if (!seg.toCode().toString().equals(str)) continue;
                result = seg;
                break;
            }
        }
        return result;
    }
}

