/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.draw.AbstractColorDrawOperation;
import adams.flow.transformer.draw.AntiAliasingDrawOperation;
import adams.gui.core.ColorHelper;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Text
extends AbstractColorDrawOperation
implements AntiAliasingDrawOperation {
    private static final long serialVersionUID = -1242368406478391978L;
    protected int m_X;
    protected int m_Y;
    protected Font m_Font;
    protected String m_Text;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Draws text with a specified font at the given location.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("font", "font", (Object)Fonts.getMonospacedFont());
        this.m_OptionManager.add("text", "text", (Object)"Hello World!");
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)true);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", Y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"font", (Object)GUIHelper.encodeFont((Font)this.m_Font), (String)", F: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"text", (Object)this.m_Text, (String)", T: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"color", (Object)ColorHelper.toHex((Color)this.m_Color), (String)", Color: ");
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the top-left corner of the text (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the top-left corner of the text (1-based).";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    public void setText(String value) {
        this.m_Text = value;
        this.reset();
    }

    public String getText() {
        return this.m_Text;
    }

    public String textTipText() {
        return "The text to draw.";
    }

    @Override
    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.reset();
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    @Override
    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing.";
    }

    @Override
    protected String check(BufferedImage image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_X > image.getWidth()) {
                result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
            } else if (this.m_Y > image.getHeight()) {
                result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
            }
        }
        return result;
    }

    @Override
    protected String doDraw(BufferedImage image) {
        if (this.m_Text.length() > 0) {
            Graphics g = image.getGraphics();
            g.setColor(this.m_Color);
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            g.setFont(this.m_Font);
            g.drawString(this.m_Text, this.m_X, this.m_Y);
        }
        return null;
    }
}

