/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.data.io.input.AbstractImageReader;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.tools.ImageProcessorSubPanel;
import adams.gui.tools.ImageProcessorTabbedPane;
import adams.gui.visualization.image.ImageViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageProcessorPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = 5882173310359920644L;
    public static final String SESSION_FILE = "ImageProcessorSession.props";
    protected ImageProcessorTabbedPane m_TabbedPane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemViewHorizontal;
    protected JMenuItem m_MenuItemViewVertical;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuViewLocateObjects;
    protected JMenuItem m_MenuViewRemoveOverlays;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;
    protected TitleGenerator m_TitleGenerator;
    protected ImageFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Image processor", true);
        this.m_FileChooser = new ImageFileChooser();
        this.m_FileChooser.setCurrentDirectory(new File(ImageViewerPanel.getProperties().getPath("InitialDir", "%h")));
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_FileChooser.setMultiSelectionEnabled(true);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new ImageProcessorTabbedPane(this);
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.m_TabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImageProcessorPanel.this.update();
            }
        });
        this.add((Component)((Object)this.m_TabbedPane), "Center");
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        this.setParentTitle(this.m_TitleGenerator.generate(this.getCurrentFile()));
    }

    public File getCurrentFile() {
        return this.m_TabbedPane.getCurrentFile();
    }

    public File getFileAt(int index) {
        return this.m_TabbedPane.getFileAt(index);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        ImageProcessorSubPanel panel = this.getCurrentPanel();
        boolean hasPanel = panel != null;
        this.m_MenuItemFileLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemFileClose.setEnabled(hasPanel);
        if (hasPanel && panel.getUndo().canUndo()) {
            this.m_MenuItemEditUndo.setEnabled(true);
            this.m_MenuItemEditUndo.setText("Undo - " + panel.getUndo().peekUndoComment(true));
        } else {
            this.m_MenuItemEditUndo.setEnabled(false);
            this.m_MenuItemEditUndo.setText("Undo");
        }
        if (hasPanel && panel.getUndo().canRedo()) {
            this.m_MenuItemEditRedo.setEnabled(true);
            this.m_MenuItemEditRedo.setText("Redo - " + panel.getUndo().peekRedoComment(true));
        } else {
            this.m_MenuItemEditRedo.setEnabled(false);
            this.m_MenuItemEditRedo.setText("Redo");
        }
        this.m_MenuItemViewHorizontal.setEnabled(hasPanel);
        this.m_MenuItemViewVertical.setEnabled(hasPanel);
        this.m_MenuViewLocateObjects.setEnabled(hasPanel);
        this.m_MenuViewRemoveOverlays.setEnabled(hasPanel);
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageProcessorPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageProcessorPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    ImageProcessorPanel.this.load(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile(), (AbstractImageReader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler());
                }
            });
            this.m_MenuItemFileLoadRecent = submenu;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setIcon(GUIHelper.getIcon((String)"close_tab_focused.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageProcessorPanel.this.close();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageProcessorPanel.this.exit();
                }
            });
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageProcessorPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Undo");
            menu.add(menuitem);
            menuitem.setMnemonic('U');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon((String)"undo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageProcessorPanel.this.undo();
                }
            });
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Redo");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Y"));
            menuitem.setIcon(GUIHelper.getIcon((String)"redo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageProcessorPanel.this.redo();
                }
            });
            this.m_MenuItemEditRedo = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageProcessorPanel.this.updateMenu();
                }
            });
            ButtonGroup group = new ButtonGroup();
            menuitem = new JRadioButtonMenuItem("Horizontal");
            menu.add(menuitem);
            menuitem.setMnemonic('H');
            menuitem.setSelected(false);
            menuitem.setIcon(GUIHelper.getIcon((String)"ip_layout_horizontal.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().setLayoutType(ImageProcessorSubPanel.LayoutType.HORIZONTAL);
                    ImageProcessorPanel.this.updateMenu();
                }
            });
            group.add(menuitem);
            this.m_MenuItemViewHorizontal = menuitem;
            menuitem = new JRadioButtonMenuItem("Vertical");
            menu.add(menuitem);
            menuitem.setMnemonic('V');
            menuitem.setSelected(true);
            menuitem.setIcon(GUIHelper.getIcon((String)"ip_layout_vertical.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().setLayoutType(ImageProcessorSubPanel.LayoutType.VERTICAL);
                    ImageProcessorPanel.this.updateMenu();
                }
            });
            group.add(menuitem);
            this.m_MenuItemViewVertical = menuitem;
            menu.addSeparator();
            submenu = new JMenu("Remove overlays");
            menu.add(submenu);
            submenu.setMnemonic('R');
            submenu.setIcon(GUIHelper.getIcon((String)"delete.gif"));
            this.m_MenuViewRemoveOverlays = submenu;
            menuitem = new JMenuItem("Original");
            submenu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().clearImageOverlays(true);
                }
            });
            menuitem = new JMenuItem("Processed");
            submenu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().clearImageOverlays(false);
                }
            });
            submenu = new JMenu("Locate objects");
            menu.add(submenu);
            submenu.setMnemonic('L');
            submenu.setIcon(GUIHelper.getIcon((String)"locateobjects.gif"));
            this.m_MenuViewLocateObjects = submenu;
            menuitem = new JMenuItem("Original");
            submenu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().locateObjects(true);
                }
            });
            menuitem = new JMenuItem("Processed");
            submenu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImageProcessorPanel.this.getCurrentPanel() == null) {
                        return;
                    }
                    ImageProcessorPanel.this.getCurrentPanel().locateObjects(false);
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public ImageProcessorSubPanel getCurrentPanel() {
        return this.m_TabbedPane.getCurrentPanel();
    }

    public ImageProcessorSubPanel getPanelAt(int index) {
        return this.m_TabbedPane.getPanelAt(index);
    }

    public ImageProcessorSubPanel[] getAllPanels() {
        return this.m_TabbedPane.getAllPanels();
    }

    protected void open() {
        File[] files;
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (File file : files = this.m_FileChooser.getSelectedFiles()) {
            this.load(file, this.m_FileChooser.getImageReader());
        }
    }

    public void load(File file) {
        this.load(file, this.m_FileChooser.getReaderForFile(file));
    }

    public void load(File file, AbstractImageReader reader) {
        if (this.m_TabbedPane.load(file, reader) && this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
        }
        this.update();
    }

    protected void close() {
        int index = this.m_TabbedPane.getSelectedIndex();
        ImageProcessorSubPanel panel = this.getPanelAt(index);
        panel.cleanUp();
        this.m_TabbedPane.remove(index);
        this.update();
    }

    protected void exit() {
        int i = 0;
        while (i < this.m_TabbedPane.getTabCount()) {
            this.m_TabbedPane.remove(i);
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public void undo() {
        ImageProcessorSubPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.undo();
    }

    public void redo() {
        ImageProcessorSubPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.redo();
    }
}

