/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.data.io.input.AbstractImageReader;
import adams.gui.core.DragAndDropTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.tools.ImageProcessorPanel;
import adams.gui.tools.ImageProcessorSubPanel;
import java.awt.Component;
import java.io.File;

public class ImageProcessorTabbedPane
extends DragAndDropTabbedPane {
    private static final long serialVersionUID = 4949565559707097445L;
    protected ImageProcessorPanel m_Owner;

    public ImageProcessorTabbedPane(ImageProcessorPanel owner) {
        this.m_Owner = owner;
        this.setShowCloseTabButton(true);
    }

    public ImageProcessorPanel getOwner() {
        return this.m_Owner;
    }

    public ImageProcessorSubPanel getCurrentPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    public ImageProcessorSubPanel getPanelAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return null;
        }
        return (ImageProcessorSubPanel)((Object)this.getComponentAt(index));
    }

    public ImageProcessorSubPanel[] getAllPanels() {
        ImageProcessorSubPanel[] result = new ImageProcessorSubPanel[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            result[i] = (ImageProcessorSubPanel)((Object)this.getComponentAt(i));
        }
        return result;
    }

    public File getCurrentFile() {
        return this.getFileAt(this.getSelectedIndex());
    }

    public File getFileAt(int index) {
        File result = null;
        ImageProcessorSubPanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getCurrentFile();
        }
        return result;
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        ImageProcessorSubPanel panel = new ImageProcessorSubPanel();
        if (!panel.load(file, reader)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to open image '" + file + "'!"));
            return false;
        }
        this.addTab(file.getName(), (Component)((Object)panel));
        this.setSelectedComponent((Component)((Object)panel));
        return true;
    }
}

