/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractPaintingSelectionProcessor;
import java.awt.Graphics;
import java.awt.Point;

public class PaintSelection
extends AbstractPaintingSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    public static final String PREFIX = "Paint.";
    public static final String KEY_X = "x";
    public static final String KEY_Y = "y";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_HEIGHT = "height";

    public String globalInfo() {
        return "Paints the selection in the specified color. Stores the rectangle in the report (prefix: Paint.). Offers undo/redo.";
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        int x = panel.mouseToPixelLocation((Point)topLeft).x;
        int y = panel.mouseToPixelLocation((Point)topLeft).y;
        int width = panel.mouseToPixelLocation((Point)bottomRight).x - panel.mouseToPixelLocation((Point)topLeft).x + 1;
        int height = panel.mouseToPixelLocation((Point)bottomRight).y - panel.mouseToPixelLocation((Point)topLeft).y + 1;
        Report additional = new Report();
        additional.setNumericValue("Paint.x", (double)x);
        additional.setNumericValue("Paint.y", (double)y);
        additional.setNumericValue("Paint.width", (double)width);
        additional.setNumericValue("Paint.height", (double)height);
        panel.addUndoPoint("Saving undo data...", "Paint selection");
        Graphics g = panel.getCurrentImage().getGraphics();
        float prev = this.applyStroke(g, this.getStrokeThickness());
        g.setColor(this.getColor());
        g.drawRect(x, y, width, height);
        this.applyStroke(panel.getGraphics(), prev);
        panel.setAdditionalProperties(additional);
    }
}

