/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ImageJHelper;
import adams.data.imagej.ImagePlusContainer;
import adams.flow.sink.AbstractFileWriter;
import ij.ImagePlus;
import ij.io.FileSaver;

public class ImageJWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 7509908838736709270L;
    protected ImageType m_ImageType;

    public String globalInfo() {
        return "Actor for saving an ImagePlus object as image file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)ImageType.AUTO);
    }

    public String getQuickInfo() {
        String result = (Object)((Object)this.m_ImageType) + ": " + super.getQuickInfo();
        return result;
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setImageType(ImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public ImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The type of image to create.";
    }

    public Class[] accepts() {
        return new Class[]{ImagePlusContainer.class};
    }

    protected ImageType determineImageType(String filename) {
        ImageType result = ImageType.PNG;
        String filenameLower = filename.toLowerCase();
        if (filenameLower.endsWith(".bmp")) {
            result = ImageType.BMP;
        } else if (filenameLower.endsWith(".fits")) {
            result = ImageType.FITS;
        } else if (filenameLower.endsWith(".gif")) {
            result = ImageType.GIF;
        } else if (filenameLower.endsWith(".jpeg") || filenameLower.endsWith(".jpg")) {
            result = ImageType.JPEG;
        } else if (filenameLower.endsWith(".lut")) {
            result = ImageType.LUT;
        } else if (filenameLower.endsWith(".pgm") || filenameLower.endsWith(".ppm")) {
            result = ImageType.PGM;
        } else if (filenameLower.endsWith(".png")) {
            result = ImageType.PNG;
        } else if (filenameLower.endsWith(".raw")) {
            result = ImageType.RAW;
        } else if (filenameLower.endsWith(".txt")) {
            result = ImageType.TEXT;
        } else if (filenameLower.endsWith(".tiff") || filenameLower.endsWith(".tif")) {
            result = ImageType.TIFF;
        } else {
            this.debug("Cannot determine image type for: " + filenameLower);
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            ImageJHelper.setPluginsDirectory();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        ImagePlusContainer img = (ImagePlusContainer)((Object)this.m_InputToken.getPayload());
        String filename = this.m_OutputFile.getAbsolutePath();
        ImageType type = this.m_ImageType == ImageType.AUTO ? this.determineImageType(filename) : this.m_ImageType;
        try {
            FileSaver saver = new FileSaver((ImagePlus)img.getImage());
            switch (type) {
                case BMP: {
                    saver.saveAsBmp(filename);
                    break;
                }
                case FITS: {
                    saver.saveAsFits(filename);
                    break;
                }
                case GIF: {
                    saver.saveAsGif(filename);
                    break;
                }
                case JPEG: {
                    FileSaver.setJpegQuality((int)100);
                    saver.saveAsJpeg(filename);
                    break;
                }
                case LUT: {
                    saver.saveAsLut(filename);
                    break;
                }
                case PGM: {
                    saver.saveAsPgm(filename);
                    break;
                }
                case PNG: {
                    saver.saveAsPng(filename);
                    break;
                }
                case RAW: {
                    saver.saveAsRaw(filename);
                    break;
                }
                case TEXT: {
                    saver.saveAsText(filename);
                    break;
                }
                case TIFF: {
                    saver.saveAsTiff(filename);
                    break;
                }
                case ZIP: {
                    saver.saveAsZip(filename);
                    break;
                }
                default: {
                    result = "Unhandled image type: " + (Object)((Object)this.m_ImageType);
                    break;
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to write image to: " + this.m_OutputFile, e);
        }
        return result;
    }

    public static enum ImageType {
        AUTO,
        BMP,
        FITS,
        GIF,
        JPEG,
        LUT,
        PGM,
        PNG,
        RAW,
        TEXT,
        TIFF,
        ZIP;

    }
}

