/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.data.jai.BufferedImageContainer;
import adams.flow.sink.AbstractFileWriter;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.JAI;

public class JAIWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 1824012225640852716L;
    protected ImageType m_ImageType;

    public String globalInfo() {
        return "Writes an image to disk using Java Advanced Imaging (JAI).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)ImageType.AUTO);
    }

    public String getQuickInfo() {
        String result = this.m_ImageType.getType() + ": " + super.getQuickInfo();
        return result;
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setImageType(ImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public ImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The type of image to create.";
    }

    public Class[] accepts() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected ImageType determineImageType(String filename) {
        ImageType result = null;
        for (ImageType type : ImageType.values()) {
            if (!type.matches(filename)) continue;
            result = type;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Failed to determine image type for '" + filename + "'!");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        BufferedImageContainer img = (BufferedImageContainer)((Object)this.m_InputToken.getPayload());
        String filename = this.m_OutputFile.getAbsolutePath();
        try {
            ImageType type = this.m_ImageType == ImageType.AUTO ? this.determineImageType(filename) : this.m_ImageType;
            JAI.create((String)"filestore", (RenderedImage)((RenderedImage)img.getImage()), (Object)filename, (Object)type.toRaw());
        }
        catch (Exception e) {
            result = this.handleException("Failed to write image to: " + this.m_OutputFile, e);
        }
        return result;
    }

    public static enum ImageType implements EnumWithCustomDisplay<ImageType>
    {
        AUTO("AUTO", "", "Automatic"),
        BMP("BMP", "bmp", "Microsoft Windows bitmap"),
        JPEG("JPEG", "jpg", "Joint Photographic Experts Group JFIF format"),
        PNG("PNG", "png", "Portable Network Graphics"),
        PNM("PNM", "pnm", "Portable anymap"),
        TIFF("TIFF", "tiff", "Tagged Image File Format");

        private String m_Raw = super.toString();
        private String m_Type;
        private String m_Extension;
        private String m_Description;

        private ImageType(String type, String ext, String desc) {
            this.m_Type = type;
            this.m_Extension = ext;
            this.m_Description = desc;
        }

        public String toDisplay() {
            return this.m_Type + " - " + this.m_Description;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public String getType() {
            return this.m_Type;
        }

        public String getExtension() {
            return this.m_Extension;
        }

        public boolean matches(File file) {
            return this.matches(file.getPath());
        }

        public boolean matches(String filename) {
            return filename.toLowerCase().endsWith("." + this.m_Extension);
        }

        public ImageType parse(String s) {
            return ImageType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((ImageType)((Object)object)).toRaw();
        }

        public static ImageType valueOf(AbstractOption option, String str) {
            ImageType result = null;
            try {
                result = ImageType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (ImageType dt : ImageType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

