/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.BufferedImageHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.data.image.AbstractImage;
import adams.data.jai.BufferedImageContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.draw.AbstractDrawOperation;
import adams.flow.transformer.draw.Pixel;
import java.awt.image.BufferedImage;

public class Draw
extends AbstractTransformer
implements InPlaceProcessing {
    private static final long serialVersionUID = -7871688022041775952L;
    protected boolean m_NoCopy;
    protected AbstractDrawOperation m_Operation;

    public String globalInfo() {
        return "Performs a draw operation on an image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new Pixel());
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no-copy", (String)", ");
        return result;
    }

    public void setOperation(AbstractDrawOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractDrawOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The draw operation to perform.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the spreadsheet is created before processing it.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImage.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        BufferedImage image = ((AbstractImage)this.m_InputToken.getPayload()).toBufferedImage();
        if (!this.m_NoCopy) {
            image = BufferedImageHelper.deepCopy(image);
        }
        this.m_Operation.setOwner((AbstractActor)this);
        String result = this.m_Operation.draw(image);
        if (result == null) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setReport(((AbstractImage)this.m_InputToken.getPayload()).getReport().getClone());
            cont.setImage(image);
            this.m_OutputToken = new Token((Object)cont);
        }
        return result;
    }
}

