/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImage;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class ImageInfo
extends AbstractTransformer {
    private static final long serialVersionUID = -992178802927111511L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Obtains information from the picture passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.WIDTH);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImage.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case WIDTH: 
            case HEIGHT: {
                return new Class[]{Integer.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        AbstractImage image = (AbstractImage)this.m_InputToken.getPayload();
        switch (this.m_Type) {
            case WIDTH: {
                this.m_OutputToken = new Token((Object)image.getWidth());
                break;
            }
            case HEIGHT: {
                this.m_OutputToken = new Token((Object)image.getHeight());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
            }
        }
        return result;
    }

    public static enum InfoType {
        WIDTH,
        HEIGHT;

    }
}

