/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.io.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.core.Stream2BufferedImage;
import org.im4java.process.InputProvider;
import org.im4java.process.OutputConsumer;
import org.im4java.process.Pipe;

public class ImageMagickHelper {
    public static final String ENV_PATH = "IM4JAVA_TOOLPATH";
    protected static Boolean m_ConvertPresent;

    public static boolean isConvertAvailable() {
        if (m_ConvertPresent == null) {
            String exec = FileUtils.fixExecutable((String)"convert");
            String path = System.getenv(ENV_PATH);
            if (path != null) {
                exec = path + File.separator + exec;
            }
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{exec, "-version"});
                m_ConvertPresent = proc.waitFor() == 0;
            }
            catch (Exception e) {
                System.err.println("Failed to execute '" + exec + "':");
                e.printStackTrace();
                m_ConvertPresent = false;
            }
        }
        return m_ConvertPresent;
    }

    protected static String getMissingCommandErrorMessage(String cmd) {
        return "ImageMagick (i.e., '" + cmd + "' command) not installed or " + ENV_PATH + " environment variable not pointing to installation!";
    }

    public static String getMissingConvertErrorMessage() {
        return ImageMagickHelper.getMissingCommandErrorMessage("convert");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File file) {
        BufferedImage result;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file.getAbsoluteFile());
            result = ImageMagickHelper.read(stream);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from '" + file + "':");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL url) {
        BufferedImage result;
        InputStream stream = null;
        try {
            stream = url.openStream();
            result = ImageMagickHelper.read(stream);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from '" + url + "':");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static BufferedImage read(InputStream stream) {
        BufferedImage result;
        IMOperation op = new IMOperation();
        op.addImage(new String[]{"-"});
        op.addImage(new String[]{"-"});
        Stream2BufferedImage s2b = new Stream2BufferedImage();
        ConvertCmd cmd = new ConvertCmd();
        cmd.setInputProvider((InputProvider)new Pipe(stream, null));
        cmd.setOutputConsumer((OutputConsumer)s2b);
        try {
            cmd.run((Operation)op, new Object[0]);
            result = s2b.getImage();
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from stream:");
            e.printStackTrace();
        }
        return result;
    }
}

