/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;

public class NamedSetup
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractBoofCVTransformer m_ActualScheme;

    public String globalInfo() {
        return "Applies a BoofCV flattener that is referenced via its global setup name (see 'NamedSetups').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getLogger().severe("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractBoofCVTransformer getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractBoofCVTransformer)((Object)this.m_Setup.getSetup());
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        return (BoofCVImageContainer[])this.getActualScheme().transform(img);
    }
}

