/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.AbstractScriptedTransformer;

public class Scripted
extends AbstractScriptedTransformer {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractImageJTransformer m_TransformerObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "An image transformer that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractImageJTransformer.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void checkImage(ImagePlusContainer img) {
        super.checkImage(img);
        this.m_TransformerObject = (AbstractImageJTransformer)((Object)this.m_ScriptObject);
    }

    public ImagePlusContainer[] doTransform(ImagePlusContainer img) {
        return (ImagePlusContainer[])this.m_TransformerObject.transform(img);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_TransformerObject = null;
    }
}

