/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Histogram
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -8349656592325229512L;
    protected HistogramType m_HistogramType;

    public String globalInfo() {
        return "Turns an image into a histogram.\nIn case of an 8-bit histogram, the image must already be converted to a gray image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("histo-type", "histogramType", (Object)HistogramType.RGB);
    }

    public void setHistogramType(HistogramType value) {
        this.m_HistogramType = value;
        this.reset();
    }

    public HistogramType getHistogramType() {
        return this.m_HistogramType;
    }

    public String histogramTypeTipText() {
        return "The type of histogram to generate.";
    }

    @Override
    public Instances createHeader(BufferedImageContainer img) {
        int numAtts = 256;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        block4: for (int i = 0; i < numAtts; ++i) {
            switch (this.m_HistogramType) {
                case EIGHT_BIT: {
                    atts.add(new Attribute("histo_" + (i + 1)));
                    continue block4;
                }
                case RGB: {
                    atts.add(new Attribute("histo_r_" + (i + 1)));
                    atts.add(new Attribute("histo_g_" + (i + 1)));
                    atts.add(new Attribute("histo_b_" + (i + 1)));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
                }
            }
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(BufferedImageContainer img) {
        double[] high;
        double[] low;
        int[] bins;
        Instance[] result = null;
        double[] values = this.newArray(this.m_Header.numAttributes());
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                bins = new int[]{256};
                low = new double[]{0.0};
                high = new double[]{256.0};
                break;
            }
            case RGB: {
                bins = new int[]{256, 256, 256};
                low = new double[]{0.0, 0.0, 0.0};
                high = new double[]{256.0, 256.0, 256.0};
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
            }
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(PlanarImage.wrapRenderedImage((RenderedImage)((RenderedImage)img.getImage())));
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(bins);
        pb.add(low);
        pb.add(high);
        RenderedOp dst = JAI.create((String)"histogram", (ParameterBlock)pb, null);
        javax.media.jai.Histogram hist = (javax.media.jai.Histogram)dst.getProperty("histogram");
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                for (int i = 0; i < 256; ++i) {
                    values[i] = hist.getBinSize(0, i);
                }
                break;
            }
            case RGB: {
                for (int i = 0; i < 256; ++i) {
                    values[i * 3 + 0] = hist.getBinSize(0, i);
                    if (hist.getNumBands() <= 1) continue;
                    values[i * 3 + 1] = hist.getBinSize(1, i);
                    values[i * 3 + 2] = hist.getBinSize(2, i);
                }
                break;
            }
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }

    public static enum HistogramType implements EnumWithCustomDisplay<HistogramType>
    {
        EIGHT_BIT("8-bit"),
        RGB("RGB");

        private String m_Display;
        private String m_Raw;

        private HistogramType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public HistogramType parse(String s) {
            return HistogramType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((HistogramType)((Object)object)).toRaw();
        }

        public static HistogramType valueOf(AbstractOption option, String str) {
            HistogramType result = null;
            try {
                result = HistogramType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (HistogramType dt : HistogramType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

