/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.image.AbstractImage;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.AbstractScriptedTransformer;

public class Scripted
extends AbstractScriptedTransformer {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractJAITransformer m_TransformerObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "An image transformer that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractJAITransformer.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void checkImage(BufferedImageContainer img) {
        super.checkImage(img);
        this.m_TransformerObject = (AbstractJAITransformer)((Object)this.m_ScriptObject);
    }

    public BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        return (BufferedImageContainer[])this.m_TransformerObject.transform((AbstractImage)img);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_TransformerObject = null;
    }
}

